CONTAINER Tlighttag
{
	NAME Tlighttag;
	INCLUDE Tbase;

	GROUP TACHYON_GENERAL_GROUP
	{
		COLOR TACHYON_LIGHTTAG_LIGHT_COLOR { OPEN; }
		REAL TACHYON_LIGHTTAG_INTENSITY {CUSTOMGUI REALSLIDER; MIN 0.0; STEP 1.0; MINSLIDER 0.0; MAXSLIDER 100.0; UNIT PERCENT; }

		LONG TACHYON_LIGHTTAG_TYPE
		{
			CYCLE
			{
				TACHYON_LIGHTTAG_TYPE_OMNIDIRECTIONAL;
				TACHYON_LIGHTTAG_TYPE_SPOTLIGHT;
				TACHYON_LIGHTTAG_TYPE_INFINITE_LIGHT;
                TACHYON_LIGHTTAG_TYPE_AREA_LIGHT;
			}
		}	
		
		LONG TACHYON_LIGHTTAG_ATTENUATION_PRESET
		{
			CYCLE
			{
				TACHYON_LIGHTTAG_ATTENUATION_PRESET_1;
				TACHYON_LIGHTTAG_ATTENUATION_PRESET_2;
				TACHYON_LIGHTTAG_ATTENUATION_PRESET_3;
				TACHYON_LIGHTTAG_ATTENUATION_PRESET_4;
				TACHYON_LIGHTTAG_ATTENUATION_PRESET_5;
			}
		}	

		REAL TACHYON_LIGHTTAG_FALLOFF_INNER_RADIUS { MIN 0.0; }
		REAL TACHYON_LIGHTTAG_FALLOFF_OUTER_RADIUS { MIN 0.0; }

		SEPARATOR { LINE; }

		GROUP
		{
			COLUMNS 3;

			BOOL TACHYON_LIGHTTAG_CLIP_NEAR_ENABLED	{ }
			REAL TACHYON_LIGHTTAG_CLIP_NEAR_FROM	{ UNIT METER; MIN 0.0; }
			REAL TACHYON_LIGHTTAG_CLIP_NEAR_TO		{ UNIT METER; MIN 0.0; }

			BOOL TACHYON_LIGHTTAG_CLIP_FAR_ENABLED	{ }
			REAL TACHYON_LIGHTTAG_CLIP_FAR_FROM		{ UNIT METER; MIN 0.0; }
			REAL TACHYON_LIGHTTAG_CLIP_FAR_TO		{ UNIT METER; MIN 0.0; }
		}

		SEPARATOR { LINE; }

		REAL TACHYON_LIGHTTAG_LIGHT_CONE_INNER_ANGLE { MIN 0.0; MAX 175.0; UNIT DEGREE;}
		REAL TACHYON_LIGHTTAG_LIGHT_CONE_OUTER_ANGLE { MIN 0.0; MAX 175.0; UNIT DEGREE;}

		SEPARATOR { LINE; } //--------------------------------------------------------------------------------
        GROUP TACHYON_LIGHTTAG_AREA_LIGHT_SETTINGS
        {
		    LONG TACHYON_LIGHTTAG_AREA_LIGHT_SHAPE
            {
                CYCLE
                {
                    TACHYON_LIGHTTAG_AREA_LIGHT_SHAPE_DISC;
                    TACHYON_LIGHTTAG_AREA_LIGHT_SHAPE_RECTANGLE;
                    //TACHYON_LIGHTTAG_AREA_LIGHT_SHAPE_LINE;
                    //TACHYON_LIGHTTAG_AREA_LIGHT_SHAPE_SPHERE;
                    //TACHYON_LIGHTTAG_AREA_LIGHT_SHAPE_CYLINDER;
                    //TACHYON_LIGHTTAG_AREA_LIGHT_SHAPE_PCYLINDER;
                    //TACHYON_LIGHTTAG_AREA_LIGHT_SHAPE_CUBE;
                    //TACHYON_LIGHTTAG_AREA_LIGHT_SHAPE_HEMISPHERE;
                    //TACHYON_LIGHTTAG_AREA_LIGHT_SHAPE_OBJECT;
                }
            }

		    REAL TACHYON_LIGHTTAG_AREA_LIGHT_SIZEX { UNIT METER; MIN 0.0; FORBID_SCALING; } // Forbid Scaling - as outerradius already scales it
		    REAL TACHYON_LIGHTTAG_AREA_LIGHT_SIZEY { UNIT METER; MIN 0.0; FORBID_SCALING; }
		    REAL TACHYON_LIGHTTAG_AREA_LIGHT_SIZEZ { UNIT METER; MIN 0.0; FORBID_SCALING; }
            BOOL TACHYON_LIGHTTAG_AREA_LIGHT_SHOW_SURFACE { }
        }
		SEPARATOR { LINE; } //--------------------------------------------------------------------------------

		//REAL TACHYON_LIGHTTAG_SPOT_OUTER_DISTANCE {MIN 0.0; STEP 0.1;} curently not used 

		// REAL TACHYON_LIGHTTAG_RANGE { MIN 0.0; STEP 0.1; } currently not used

        BOOL TACHYON_LIGHTTAG_ONE_SIDED_EMISSION { }

		BOOL TACHYON_LIGHTTAG_DIFFUSE_ENABLED { }
		BOOL TACHYON_LIGHTTAG_SPECULAR_ENABLED { }
        BOOL TACHYON_LIGHTTAG_VOLUMETRICS_ENABLED { }

		DEFAULT 1;
	}
	
	GROUP TACHYON_SHADOW_GROUP
	{
		LONG TACHYON_LIGHTTAG_SHADOW_MODE
		{
			CYCLE
			{
				TACHYON_LIGHTTAG_SHADOW_MODE_NONE;
				TACHYON_LIGHTTAG_SHADOW_MODE_HARD;
				TACHYON_LIGHTTAG_SHADOW_MODE_FILTERED;
				//TACHYON_LIGHTTAG_SHADOW_MODE_CONTACT_HARDENING;
			}
		}

		//LONG TACHYON_LIGHTTAG_SOFT_SHADOW_MODE
		//{
		//	CYCLE
		//	{
		//		TACHYON_LIGHTTAG_SOFT_SHADOW_MODE_MVR;
		//		TACHYON_LIGHTTAG_SOFT_SHADOW_MODE_PCSS;
		//	}
		//}
						
		COLOR TACHYON_LIGHTTAG_SHADOW_COLOR	{ }

		SEPARATOR { LINE; } //--------------------------------------------------------------------------------

		LONG TACHYON_LIGHTTAG_SHADOW_MAP_SIZE
		{
			CYCLE
			{
				TACHYON_LIGHTTAG_SHADOW_MAP_SIZE_USE_DEFAULT;
				TACHYON_LIGHTTAG_SHADOW_MAP_SIZE_256;
				TACHYON_LIGHTTAG_SHADOW_MAP_SIZE_512;
				TACHYON_LIGHTTAG_SHADOW_MAP_SIZE_1024;
				TACHYON_LIGHTTAG_SHADOW_MAP_SIZE_2048;
				TACHYON_LIGHTTAG_SHADOW_MAP_SIZE_4096;
				TACHYON_LIGHTTAG_SHADOW_MAP_SIZE_8192;
				TACHYON_LIGHTTAG_SHADOW_MAP_SIZE_16384;
			};
			ANIM OFF;
		}

		LONG TACHYON_LIGHTTAG_SHADOW_CASCADE_COUNT			{ MIN 1; MAX 8; ANIM OFF;}
		REAL TACHYON_LIGHTTAG_SHADOW_CASCADE_SPLIT_WEIGHT	{ MIN 0.0; MAX 1.0; STEP 0.01; ANIM OFF; }

		REAL TACHYON_LIGHTTAG_SHADOW_SAMPLE_SIZE { MIN 0.0; MAX 20.0; STEP 0.01; }

		REAL TACHYON_LIGHTTAG_SHADOW_ABSOLUTE_BIAS { MIN 0.0; STEP 0.001; }
		REAL TACHYON_LIGHTTAG_SHADOW_SLOPE_BIAS { MIN 0.0; STEP 0.001; }

        GROUP
        {
            COLUMNS 2;
            REAL TACHYON_LIGHTTAG_SHADOW_MAP_CUSTOM_SHADOW_RANGE { PARENTID TACHYON_LIGHTTAG_SHADOW_SLOPE_BIAS; MIN 0.0; STEP 0.1; ANIM OFF; UNIT METER; }
            BOOL TACHYON_LIGHTTAG_SHADOW_MAP_AUTOMATIC_SHADOW_RANGE_ENABLED { ANIM OFF; }
        }

        GROUP TACHYON_SHADOW_GROUP_VOLUMETRICS
	    {
		    COLUMNS 1; DEFAULT 1;

            BOOL TACHYON_LIGHTTAG_VOLUMETRICS_CAST_OBJECT_SHADOWS { }

            SEPARATOR { LINE; } //--------------------------------------------------------------------------------

		    BOOL TACHYON_LIGHTTAG_VOLUMETRICS_EXTINCTION_SHADOWS_ENABLED { }
		    VECTOR TACHYON_LIGHTTAG_VOLUMETRICS_EXTINCTION_RESOLUTION_XYZ { ANIM OFF; MIN 4; MAX 64; STEP 1; }
		    LONG TACHYON_LIGHTTAG_VOLUMETRICS_EXTINCTION_RESOLUTION_SCALE { ANIM OFF; CUSTOMGUI LONGSLIDER; MIN 1; MAX 10; }
			REAL TACHYON_LIGHTTAG_VOLUMETRICS_EXTINCTION_SHADOW_RANGE { UNIT METER; MIN 0.1; STEP 0.1; }
	    }
	}
}
